function pi_models = build_lines(idx_from, idx_to, R_prime, X_prime, B_prime, l, V_b, A_b)
% 
% INPUT
%   idx_from    Index of start bus.
%   idx_to      Index of end bus.
%   R_prime     Branch resistance in Ohm/km.
%   X_prime     Branch reactance in Ohm/km.
%   B_prime     Shunt susceptance in Siemens/km.
%   l           Length in km.
%   V_b         Base voltage in V
%   A_b         Base power in VA.
% 
% OUTPUT
%   pi_models   Per-unit pi-section equivalent circuits.

n_lines = length(idx_from);

pi_models = cell(n_lines,1);

for k=1:n_lines    
    pi_k = struct();
    
    % **********
    
    % !!! write your own code here !!!
    
    pi_k.i = [];
    pi_k.j = [];
    pi_k.Y_ij = [];
    pi_k.Y_i_ij = [];
    pi_k.Y_j_ij = [];
    
    % **********
    
    pi_models{k} = pi_k;
end

pi_models = [pi_models{:}];

end